<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Horaires extends Model 
{

    protected $table = 'horaires';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function matieres()
    {
        return $this->morphedByMany('App\Models\Matiere', 'horaireable');
    }

    public function ateliers()
    {
        return $this->morphedByMany('App\Models\Atelier', 'horaireable');
    }

    public function achats()
    {
        return $this->belongsToMany('App\Models\Achat');
    }

    public function lecons()
    {
        return $this->hasMany('App\Models\Lecon');
    }

}